#ifndef Z_INTERFACE_H
#define Z_INTERFACE_H

#include "SimpleGXCREF_OuterEnum.h"
#include "SimpleGXCREF_type.h"

#define DLL_EXPORT  __declspec(dllexport)






/// <summary>
/// Simple MX
/// </summary>
class DLL_EXPORT MX
{
private:
	char* IPAddress;
	QBYTE CPUType;
	char CPUName[15];

	QWORD Port = 0;
	QWLONG sock = 0;
	QWORD global_cnt = 0;
	MC_Setting param;


	void CommonInit(QBYTE MCProtocol, char* IPAddress);
	void ParamSet();

public:
	QBYTE identify[2] = { 0xAA,0xBB };
	QBYTE ActSourceUnitNumber = 0x00;
	QBYTE ActNetworkNumber = 0x00;
	QBYTE ActUnitNumber = 0xFF;
	QWORD ActIONumber = 0x03FF;
	QBYTE ActConnectUnitNumber = 0x00;
	QBYTE ActSourceStation = 0x00;
	QWORD CPUTimer = 0x1000;
	QBYTE isBinary = (char)enumIsBinary::True;
	QBYTE QiQ = (char)enumPLC::Q;
	QBYTE Frame = (char)enumMCFrame::C2;
	QBYTE Protocol = (char)enumMCProtocol::GXSim2;



	~MX() noexcept;


	/// <summary>GX Simulator2 pRXgN^</summary>
	MX(char CPUType, QBYTE MCProtocol);

	/// <summary>MCvgR(3E, 4E) pRXgN^</summary>
	MX(char* IPAddress, QWORD IPPort, QBYTE MCProtocol, QBYTE QiQ);  

	/// <summary>M^CAEg</summary>
	QWORD  TimeoutSec = 1;

	
	int getCPUName(char* cpuName);


	/// <summary>\PbgI[v</summary>
	QWLONG SockOpen();

	/// <summary>\PbgN[Y</summary>
	int SockClose();

	/// <summary>\PbgN[Y</summary>
	int SockClose(int sock);


	/// <summary></summary>
	void MX::freeRcv(RcvWORD* p);

	///////////

/// <summary>foCX̃f[^ǂݍ</summary>
/// <param name="dev"> dev[0]="D0", dev[1]="D1"... Ƃz ŃfoCXԍQw</param>
/// <param name="figs">_w</param>
/// <param name="dat"> Ǎf[^</param>
/// <returns></returns>
	int ReadDeviceRandom(char* dev[], QWORD words, QWORD* dat);


/// <summary>foCX̃f[^ǂݍ</summary>
/// <param name="dev">"D0\nD3..." ŃfoCXԍQw</param>
/// <param name="figs">_w</param>
/// <returns></returns>
	int ReadDeviceRandom(char* dev, QWORD words, QWORD* dat);


	/// <summary>foCXɃf[^</summary>
/// <param name="dev"> dev[0]="D0", dev[1]="D1"... Ƃz ŃfoCXԍQw</param>
/// <param name="figs">_w</param>
/// <param name="dat"> f[^</param>
/// <returns></returns>
	int WriteDeviceRandom(char* dev[], QWORD words, QWORD* dat);


	/// <summary>foCXɃf[^</summary>
/// <param name="dev">"D0\nD3..." ŃfoCXԍQw</param>
/// <param name="figs">_w</param>
/// <param name="dat"> f[^</param>
/// <returns></returns>
	int WriteDeviceRandom(char* dev, QWORD words, QWORD* dat);



	/// <summary>foCX̃f[^ǂݍ</summary>
	/// <param name="dev">"D0" ōŏ̃foCXԍw</param>
	/// <param name="figs">_w</param>
	/// <param name="dat"> Ǎf[^</param>
	/// <returns></returns>
	int ReadDeviceBlock(char* dev, QWORD words, QWORD* dat);

	/// <summary>foCXɃf[^</summary>
/// <param name="dev">"D0" ōŏ̃foCXԍw</param>
/// <param name="figs">_w</param>
/// <param name="dat"> f[^</param>
/// <returns></returns>
	int WriteDeviceBlock(char* dev, QWORD words, QWORD* dat);


	int WriteBitDeviceBlock(char* dev, QWORD words, QWORD* dat);
	int ReadBitDeviceBlock(char* dev, QWORD words, QWORD* dat);

	int WriteBitDeviceRandom(char* dev, QWORD words, QWORD* dat);
	int WriteBitDeviceRandom(char* dev[], QWORD words, QWORD* dat);

	/* ݂
	int ReadBitDeviceRandom(char* dev, QWORD words, QWORD* dat);
	int ReadBitDeviceRandom(char* dev[], QWORD words, QWORD* dat);
	*/


/// <summary>obt@ǂݍ (GX Simulator3 ł͎gps)</summary>
/// <param name="IONo">擪 IONo(/0x10) </param>
/// <param name="IOAdd">擪AhX </param>
/// <param name="words">[hw</param>
/// <param name="dat"> Ǎf[^</param>
/// <returns></returns>
    int ReadBuffer(QWORD IONo, QWORD IOAdd, QWORD words, QWORD* dat);


	/// <summary>obt@ (GX Simulator3 ł͎gps)</summary>
/// <param name="IONo">擪 IONo(/0x10) </param>
/// <param name="IOAdd">擪AhX </param>
/// <param name="words">[hw</param>
/// <param name="dat">f[^</param>
/// <returns></returns>
    int WriteBuffer(QWORD IONo, QWORD IOAdd, QWORD words, QWORD * dat);




	/// <summary>foCX1_ǂݍ</summary>
/// <param name="dev"> "D0"ŃfoCXԍw</param>
/// <param name="dat">Ǎf[^</param>
/// <returns></returns>
	int GetDevice(char* dev, QWORD &dat);


	/// <summary>foCX1_Ƀf[^</summary>
/// <param name="dev"> "D0"ŃfoCXԍw</param>
/// <param name="dat"> f[^</param>
/// <returns></returns>
	int SetDevice(char* dev, QWORD dat);






};








#endif