
#ifndef Z_TYPEDEF_H
#define Z_TYPEDEF_H

typedef unsigned long long QWLONG;
typedef unsigned long QLONG;
typedef unsigned short QWORD;
typedef unsigned int QDWORD;
typedef unsigned char QBYTE;



typedef struct {
	QBYTE identify[2] = { 0xAA,0xBB };
	QBYTE ActSourceUnitNumber = 0x00;
	QBYTE ActNetworkNumber = 0x00;
	QBYTE ActUnitNumber = 0xFF;
	QWORD ActIONumber = 0x03FF;
	QBYTE ActConnectUnitNumber = 0x00;
	QBYTE ActSourceStation = 0x00;
	QWORD CPUTimer = 0x1000;
	QBYTE isBinary = 0x01;
	QBYTE QiQ = 0x00;
	QBYTE Frame = 0x00;
	QBYTE Protocol = 0x00;
}MC_Setting;



typedef struct {
	QBYTE Success = 0x00;
	QWORD errorCode = 0x00;
} Rcv;

typedef struct {
	QBYTE Success = 0x00;
	QWORD errorCode = 0x00;
	QWORD dat[65535];
} RcvWORD;

typedef struct {
	QBYTE Success = 0x00;
	QWORD errorCode = 0x00;
	QWORD dat[65535];
} RcvDWORD;


#define DLL_EXPORT  __declspec(dllexport)
DLL_EXPORT char* d2ch_(int n);

template <typename T>
T* combStr_(T* s, ...);
template DLL_EXPORT char* combStr_(char* s, ...);
template DLL_EXPORT wchar_t* combStr_(wchar_t* s, ...);



#endif
